#!/bin/bash

operations="0"
updfirm="0"
updfdtb="0"
updboot="0"
updFtrusted="0"
upduImage=0;
mustboot="0"

#Uncompress File
filegz="/usr/local/selba318/Selba318A.gz"
if [ ! -f "$filegz" ]
then
	echo "$0: File '${filegz}' not found."
else
	echo "$0: File '${filegz}' found"
	echo "Uncompress gz file ..."
	tar -xzvf $filegz	
	rm $filegz
	sync
	echo "gz file Uncompressed"
fi

#Updates DTB
filedtb="/usr/local/selba318/stm32mp157c-dk2.dtb"
if [ ! -f "$filedtb" ]
then
	echo "$0: File '${filedtb}' not found."
else
	echo "$0: File '${filedtb}' found"
	echo "Updating dtb file ..."
	cp $filedtb /boot
	rm $filedtb
	mustboot="1"
	updfdtb="1"
	operations="1"
	echo "dtb file Updated"
fi

#Updates MICROBOOT
fileboot="/usr/local/selba318/fip-stm32mp157c-dk2-trusted.bin"
if [ ! -f "$fileboot" ]
then
	echo "$0: File '${fileboot}' not found."
else
	echo "$0: File '${fileboot}' found"
	echo "Updating Microboot ..."
	dd if=fip-stm32mp157c-dk2-trusted.bin of=/dev/mmcblk0p5
	dd if=fip-stm32mp157c-dk2-trusted.bin of=/dev/mmcblk0p6
	rm $fileboot
	mustboot="1"
	updboot="1"
	operations="1"
	echo "Microboot Updated"
fi


#Updates TRUSTED FIRMWARE
filetrusted="/usr/local/selba318/tf-a-stm32mp157c-dk2-sdcard.stm32"
if [ ! -f "$filetrusted" ]
then
	echo "$0: File '${filetrusted}' not found."
else
	echo "$0: File '${filetrusted}' found"
	echo "Updating Trusted Firmware ..."
	dd if=tf-a-stm32mp157c-dk2-sdcard.stm32 of=/dev/mmcblk0p1
	dd if=tf-a-stm32mp157c-dk2-sdcard.stm32 of=/dev/mmcblk0p2
	rm $filetrusted
	mustboot="1"
	updFtrusted="1"
	operations="1"
	echo "boot Updated"
fi

#Kernel Linux
fileuImage="/usr/local/selba318/uImage"
if [ ! -f "$fileuImage" ]
then
	echo "$0: File '${fileuImage}' not found."
else
	echo "$0: File '${fileuImage}' found"
	echo "Updating Linux Kernel file ..."
	cp $fileuImage /boot
	rm $fileuImage
	mustboot="1"
	upduImage="1"
	operations="1"
	echo "Linux Kernel Updated"
fi



#Updates Firmware
file="/usr/local/selba318/Selba318A.bin"
if [ ! -f "$file" ]
then
	echo "$0: File '${file}' not found."
else
	echo "$0: File '${file}' found"
	echo "Updating Firmware ..."
	cp $file /usr/local/selba318/Selba318A
	rm $file
	updfirm="1"
	operations="1"
	echo "Firmware Updated"
fi
sync

#write log actuations
if [[ $operations == "1" ]]
then
	date >> "update.log"
	if [[ $updfdtb == "1" ]]
	then
		echo "dtb Updated" >> "update.log"
	fi
	if [[ $updboot == "1" ]]
	then
		echo "boot Updated" >> "update.log"
	fi
	if [[ $updFtrusted == "1" ]]
	then
		echo "File Trusted Updated" >> "update.log"
	fi
	if [[ $upduImage == "1" ]]
	then
		echo "uImage Updated" >> "update.log"
	fi
	if [[ $updfirm == "1" ]]
	then
		echo "firmware Updated" >> "update.log"
	fi

fi



#Run Main Application / Reboot
chmod 777 Selba318A
if [[ $mustboot == "0" ]]
then
./Selba318A
else
echo "Rebooting..."
reboot
fi
